/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ModelBakeryAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1058;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7923;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.render.FluidRenderer;

public class FaucetFluidLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final FaucetFluidLoader INSTANCE = new FaucetFluidLoader();
    private static final class_2960 DEFAULT_NAME = Mantle.getResource("_default");
    private final Map<class_2680, FaucetFluid> fluidMap = new HashMap<class_2680, FaucetFluid>();
    private static boolean initialized = false;
    private FaucetFluid defaultFluid = FaucetFluid.EMPTY;

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
    }

    private FaucetFluidLoader() {
        super(GSON, "models/faucet_fluid");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        JsonElement def = map.get(DEFAULT_NAME);
        if (def == null || !def.isJsonObject()) {
            Mantle.logger.warn("Found no default fluid model, this is likely a problem with the resource pack");
            this.defaultFluid = FaucetFluid.EMPTY;
        } else {
            try {
                this.defaultFluid = FaucetFluid.parseDefault(def.getAsJsonObject());
            }
            catch (Exception exception) {
                Mantle.logger.error("Failed to load default faucet fluid model {}", (Object)DEFAULT_NAME, (Object)exception);
            }
        }
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 location = entry.getKey();
            if (location.equals((Object)DEFAULT_NAME) || !entry.getValue().isJsonObject()) continue;
            try {
                JsonObject json = class_3518.method_15295((JsonElement)entry.getValue(), (String)"");
                JsonObject variants = class_3518.method_15296((JsonObject)json, (String)"variants");
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(location);
                if (block != null && block != class_2246.field_10124) {
                    class_2689 container = block.method_9595();
                    ImmutableList validStates = container.method_11662();
                    for (Map.Entry variant : variants.entrySet()) {
                        FaucetFluid fluid = FaucetFluid.fromJson(class_3518.method_15295((JsonElement)((JsonElement)variant.getValue()), (String)((String)variant.getKey())), this.defaultFluid);
                        validStates.stream().filter(ModelBakeryAccessor.port_lib$predicate((class_2689)container, (String)((String)variant.getKey()))).forEach(state -> this.fluidMap.put((class_2680)state, fluid));
                    }
                    continue;
                }
                Mantle.logger.debug("Skipping loading faucet fluid model '{}' as no coorsponding block exists", (Object)location);
            }
            catch (Exception e) {
                Mantle.logger.warn("Exception loading faucet fluid model '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    public static FaucetFluid get(class_2680 state) {
        return FaucetFluidLoader.INSTANCE.fluidMap.getOrDefault(state, FaucetFluidLoader.INSTANCE.defaultFluid);
    }

    public static void renderFaucetFluids(class_1936 world, class_2338 pos, class_2350 direction, class_4587 matrices, class_4588 buffer, class_1058 still, class_1058 flowing, int color, int light) {
        FaucetFluid faucetFluid;
        int i = 0;
        do {
            faucetFluid = FaucetFluidLoader.get(world.method_8320(pos.method_10087(++i)));
            matrices.method_22903();
            matrices.method_46416(0.0f, (float)(-i), 0.0f);
            for (FluidCuboid cube : faucetFluid.getFluids(direction)) {
                FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, false);
            }
            matrices.method_22909();
        } while (faucetFluid.isContinued());
    }

    public class_2960 getFabricId() {
        return Mantle.getResource("faucet_fluid_loader");
    }

    public static class FaucetFluid {
        private static final FaucetFluid EMPTY = new FaucetFluid(Collections.emptyList(), Collections.emptyList(), false);
        private final List<FluidCuboid> side;
        private final List<FluidCuboid> center;
        private final boolean cont;

        public FaucetFluid(List<FluidCuboid> side, List<FluidCuboid> center, boolean cont) {
            this.side = side;
            this.center = center;
            this.cont = cont;
        }

        public List<FluidCuboid> getFluids(class_2350 dir) {
            if (dir.method_10166() == class_2350.class_2351.field_11052) {
                return this.center;
            }
            return this.side;
        }

        public boolean isContinued() {
            return this.cont;
        }

        protected static FaucetFluid parseDefault(JsonObject json) {
            List<FluidCuboid> side = FluidCuboid.listFromJson(json, "side");
            List<FluidCuboid> center = FluidCuboid.listFromJson(json, "center");
            return new FaucetFluid(side, center, false);
        }

        protected static FaucetFluid fromJson(JsonObject json, FaucetFluid def) {
            List<FluidCuboid> side = FaucetFluid.parseFluids(json, "side", def.side);
            List<FluidCuboid> center = FaucetFluid.parseFluids(json, "center", def.center);
            boolean cont = class_3518.method_15258((JsonObject)json, (String)"continue", (boolean)false);
            return new FaucetFluid(side, center, cont);
        }

        private static List<FluidCuboid> parseFluids(JsonObject json, String tag, List<FluidCuboid> def) {
            JsonElement element;
            if (json.has(tag)) {
                element = json.get(tag);
            } else if (json.has("bottom") && json.get("bottom").isJsonPrimitive()) {
                element = json.get("bottom");
            } else {
                return def;
            }
            if (element.isJsonPrimitive()) {
                int value = element.getAsInt();
                return def.stream().map(cuboid -> {
                    Vector3f from = new Vector3f((Vector3fc)cuboid.getFrom());
                    from.y = value;
                    return new FluidCuboid(from, cuboid.getTo(), cuboid.getFaces());
                }).collect(Collectors.toList());
            }
            return FluidCuboid.listFromJson(json, tag);
        }
    }
}

